import { http } from '@inside-library/helpers/Http'

export const fetchSpaceMinimal = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: ['uuid', 'title', 'banner', 'introduction', 'slug'],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSimpleSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/simple_spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'introduction',
        'slug',
        'admin',
        'content_type',
        {
          spaces: {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'status:eq': 1, reverse: true }
          }
        }
      ],
      filters: { 'status:eq': 1, 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      filters: { slug: $route.params.slug },
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'banner',
        'admin',
        'custom_slug',
        'display_in_multipage',
        'flash_content',
        'vignette',
        {
          spaces: ['uuid', 'title', 'slug', 'content_type', 'admin', 'vignette']
        },
        {
          spaces_pages: [
            'uuid',
            'title',
            'slug',
            'content_type',
            'admin',
            'vignette'
          ]
        },
        {
          users: ['uuid', 'firstname', 'lastname', 'image', 'function', 'phone']
        },
        {
          tools: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'admin',
              'icon',
              'image',
              'tools_link',
              'content',
              'has_section',
              {
                tools_categories: [
                  'uuid',
                  { tools_categories_listings: ['uuid', 'slug'] }
                ]
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          documents: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'admin',
              'content',
              'file',
              'image'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'chapo',
                    'published_at',
                    'image',
                    'content_type',
                    { news_categories: ['uuid', 'title'] },
                    { reactions: ['count', { users: ['uuid'] }] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    limit: 2
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          events_categories: {
            fields: [
              'uuid',
              'title',
              {
                events: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'chapo',
                    'published_at',
                    'image',
                    'content_type',
                    'date',
                    'end_date',
                    'display_hours',
                    'place',
                    { events_categories: ['uuid', 'title', 'color'] },
                    { reactions: ['count', { users: ['uuid'] }] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          blocks: {
            fields: [
              'uuid',
              'title',
              'link',
              'link_label',
              'weight',
              'admin',
              'image',
              'icon',
              'content_type',
              'background_color',
              'dark_mode'
            ],
            filters: {
              'status:eq': 1,
              sort: 'weight:asc'
            }
          }
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchBusinessSpaceMinimal = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces_business', {
      fields: ['uuid', 'title', 'banner', 'introduction', 'slug'],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchBusinessSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces_business', {
      filters: { slug: $route.params.slug },
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'banner',
        'admin',
        'custom_slug',
        'content',
        {
          users: ['uuid', 'firstname', 'lastname', 'image', 'function', 'phone']
        },
        {
          tools: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'admin',
              'icon',
              'image',
              'tools_link',
              'content'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          business_offers: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'admin',
              'chapo',
              'image',
              'slug',
              'content',
              'published_at'
            ],
            filters: {
              'status:eq': 1,
              sort: 'published_at:desc'
            }
          }
        },
        {
          documents: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'admin',
              'content',
              'file',
              'image'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news: {
            fields: [
              'uuid',
              'title',
              'slug',
              'chapo',
              'published_at',
              'image',
              'content_type',
              { news_categories: ['uuid', 'title'] },
              { reactions: ['count', { users: ['uuid'] }] }
            ],
            filters: {
              'status:eq': 1,
              sort: 'published_at:desc',
              limit: 4
            }
          }
        },
        {
          blocks: {
            fields: [
              'uuid',
              'title',
              'link',
              'link_label',
              'weight',
              'admin',
              'image',
              'icon',
              'content_type',
              'background_color',
              'dark_mode'
            ],
            filters: {
              'status:eq': 1,
              sort: 'weight:asc'
            }
          }
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
