import { http } from '@inside-library/helpers/Http'

const fetchOffers = async () => {
  try {
    const { data } = await http.get('content/spaces_business', {
      fields: [
        'uuid',
        'title',
        'image',
        'admin',
        'published_at',
        'image',
        'content_type',
        'slug'
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        limit: 1
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchSocials = async () => {
  try {
    const { data } = await http.get('content/socials', {
      fields: [
        'uuid',
        'title',
        'image',
        'icon',
        'published_at',
        'link',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        limit: 3
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchOffers, fetchSocials }
