import { http } from '@inside-library/helpers/Http'
import get from 'lodash/get'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'JobSpacePage',
      params: { slug: data.slug[0] }
    })
  },
  simpleSpaces: {
    add: async ({ data }) => {
      const { data: simpleSpaceData } = await http.get(
        'content/simple_spaces',
        {
          fields: ['uuid', 'title', 'slug', 'admin'],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      return {
        name: 'SimpleSpacePage',
        params: { slug: simpleSpaceData?.[0]?.slug?.[0] }
      }
    }
  },
  pagesCategories: {
    fields: [{ spaces: ['slug'] }, { simple_spaces: ['slug'] }],
    add: ({ data }) => {
      return data.spaces.data.length
        ? {
            name: 'JobSpacePage',
            params: {
              slug: data.spaces.data[0].slug[0]
            }
          }
        : {
            name: 'SimpleSpacePage',
            params: {
              slug: data.simple_spaces?.slug[0]
            }
          }
    },
    delete: ({ data }) => {
      return data.spaces.data.length
        ? {
            name: 'JobSpacePage',
            params: { slug: data.spaces.data[0].slug[0] }
          }
        : {
            name: 'SimpleSpacePage',
            params: {
              slug: data.simple_spaces?.slug[0]
            }
          }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            {
              spaces: {
                fields: ['slug', 'display_in_multipage'],
                filters: { 'status:eq': 1 }
              }
            },
            {
              simple_spaces: {
                fields: ['slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      const { data: spacesPage } = await http.get('content/spaces_pages', {
        fields: ['uuid'],
        filters: { reverse: true, pages_categories: { 'uuid:eq': data.uuid } }
      })

      const displayInMultipage =
        pagesCategories[0]?.spaces?.data[0]?.display_in_multipage

      const slugSpace = pagesCategories[0]?.spaces?.data[0]?.slug[0]
      const slugSimpleSpace = pagesCategories[0]?.simple_spaces?.slug[0]

      return slugSpace && displayInMultipage
        ? {
            route: {
              name: 'SpacePagesPage',
              params: { slug: slugSpace },
              query: { page: spacesPage[0]?.uuid }
            }
          }
        : {
            route: {
              name: 'SimpleSpacePage',
              params: { slug: slugSimpleSpace },
              query: { page: spacesPage[0]?.uuid }
            }
          }
    }
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: ['uuid'] }],
    add: async ({ data }) => {
      try {
        const { data: spacesPages } = await http.get('content/spaces_pages', {
          fields: [
            {
              pages_categories: {
                fields: ['uuid', 'title'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': data.uuid }
        })

        const { data: pagesCategories } = await http.get(
          'content/pages_categories',
          {
            fields: [
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug'],
                  filters: { 'status:eq': 1 }
                }
              },
              {
                simple_spaces: {
                  fields: ['uuid', 'title', 'slug'],
                  filters: { 'status:eq': 1 }
                }
              }
            ],
            filters: { 'uuid:eq': spacesPages[0].pages_categories.uuid }
          }
        )

        const slug =
          pagesCategories[0]?.spaces?.data[0]?.slug[0] ||
          pagesCategories[0]?.simple_spaces?.slug[0]

        return pagesCategories[0]?.spaces?.data[0]?.slug[0]
          ? {
              name: 'SpacePagesPage',
              params: { slug },
              query: { page: data.uuid }
            }
          : {
              name: 'SimpleSpacePage',
              params: { slug },
              query: { page: data.uuid }
            }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        let { data } = await http.get('content/spaces_pages', {
          fields: [
            {
              pages_categories: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })
        let uuidSpacePage = data[0].pages_categories.uuid

        data = await http.get('content/pages_categories', {
          fields: [
            {
              spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            },
            {
              simple_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidSpacePage }
        })

        const slug =
          data.data[0]?.spaces?.data[0]?.slug[0] ||
          data.data[0]?.simple_spaces?.slug[0]

        return data.data[0]?.spaces?.data[0]?.slug[0]
          ? {
              name: 'JobSpacePage',
              params: { slug }
            }
          : {
              name: 'SimpleSpacePage',
              params: { slug }
            }
      } catch (err) {
        return { path: '/' }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get('content/spaces_pages', {
        fields: ['uuid', { pages_categories: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: space } = await http.get('content/pages_categories', {
        fields: [
          'uuid',
          { spaces: ['uuid', 'title', 'slug'] },
          { simple_spaces: ['uuid', 'title', 'slug'] }
        ],
        filters: { 'uuid:eq': pagesCategories[0].pages_categories.uuid }
      })

      const slug =
        space[0]?.spaces?.data[0]?.slug[0] || space[0].simple_spaces.slug[0]

      return {
        route: space[0]?.spaces?.data[0]?.slug[0]
          ? {
              name: 'SpacePagesPage',
              params: { slug },
              query: { page: data.uuid }
            }
          : {
              name: 'SimpleSpacePage',
              params: { slug },
              query: { page: data.uuid }
            }
      }
    }
  },
  businessOffers: {
    add: ({ data }) => ({
      name: 'BusinessOfferPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'BusinessOffersListingPage'
    })
  },
  spacesBusiness: {
    add: ({ data }) => ({
      name: 'BusinessOfferSpacePage',
      params: { slug: data.slug[0] }
    })
  },
  pagesCategoriesBusiness: {
    fields: [{ spaces_business: ['slug'] }],
    add: ({ data }) => ({
      name: 'BusinessOfferSpacePage',
      params: { slug: data.spaces_business.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'BusinessOfferSpacePage',
      params: { slug: data.spaces_business.slug[0] }
    }),
    globalSearch: async ({ data }) => {
      const { data: space } = await http.get(
        'content/pages_categories_business',
        {
          fields: ['uuid', { spaces_business: ['slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        }
      )

      const slug = space[0]?.spaces_business?.slug[0]

      const { data: spacesBusinessPage } = await http.get(
        'content/spaces_pages_business',
        {
          fields: ['uuid'],
          filters: {
            reverse: true,
            pages_categories_business: { 'uuid:eq': data.uuid }
          }
        }
      )

      return {
        route: {
          name: 'BusinessSpacePage',
          params: { slug },
          query: { page: spacesBusinessPage[0]?.uuid }
        }
      }
    }
  },
  spacesPagesBusiness: {
    fields: ['uuid', { pages_categories_business: ['uuid'] }],
    add: async ({ data }) => {
      try {
        const { data: pagesCategories } = await http.get(
          'content/pages_categories_business',
          {
            fields: [
              {
                spaces_business: {
                  fields: ['uuid', 'title', 'slug'],
                  filters: { 'status:eq': 1 }
                }
              }
            ],
            filters: { 'uuid:eq': data.pages_categories_business.uuid }
          }
        )

        const slug = get(pagesCategories, [
          0,
          'spaces_business',
          'data',
          0,
          'slug',
          0
        ])

        return {
          name: 'BusinessOfferSpacePage',
          params: { slug },
          query: { page: data.uuid }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        let { data } = await http.get('content/spaces_pages_business', {
          fields: [
            {
              pages_categories_business: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })
        let uuidSpacePage = data[0].pages_categories_business.uuid

        data = await http.get('content/pages_categories', {
          fields: [
            {
              spaces_business: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidSpacePage }
        })

        const slug =
          get(data, ['data', 0, 'spaces_business', 'slug', 0]) ||
          get(data, ['data', 0, 'spaces_business', 'data', 0, 'slug', 0])

        return {
          name: 'BusinessOfferSpacePage',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategoriesBusiness } = await http.get(
        'content/spaces_pages_business',
        {
          fields: [
            'uuid',
            'slug',
            { pages_categories_business: ['uuid', 'title', 'slug'] }
          ],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      const { data: space } = await http.get(
        'content/pages_categories_business',
        {
          fields: ['uuid', { spaces_business: ['uuid', 'title', 'slug'] }],
          filters: {
            'uuid:eq': pagesCategoriesBusiness[0].pages_categories_business.uuid
          }
        }
      )

      const slug = space[0]?.spaces_business?.slug[0]

      return {
        route: {
          name: 'BusinessSpacePage',
          params: { slug },
          query: { page: data.uuid }
        }
      }
    }
  }
}
