import SamlAuth from './components/auth/SamlAuth.vue'

export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-auth': {
    extraComponent: {
      is: SamlAuth
    }
  },
  'inside-commons': {
    banner: {
      useEmptyBanner: true
    }
  },
  'inside-events': {
    subscriptionEnabled: true,
    reportEnabled: true
  },
  'inside-layouts': {
    reportEnabledOnSimplePages: true,
    reportEnabledOnGroupWithTabs: true
  },
  'inside-news': {
    bookmarkEnabled: false,
    showBookmarks: false
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    shortcuts: {
      max: 6
    }
  }
}
