<?php

namespace Inside\CUIS\Providers;

use Inside\Content\Events\ContentUpdatedEvent;
use Inside\CUIS\Listeners\OverwriteBannerPageStyle;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

final class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentUpdatedEvent::class => [
            OverwriteBannerPageStyle::class
        ]
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/archive.php', 'archive');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
        }
    }
}
