<?php

namespace Inside\CUIS\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Modal;
use Inside\Reaction\Facades\Reactions;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class ModalReactionController extends Controller
{
    public function get(string $type): JsonResponse
    {
        $modal = Modal::where('modal_type', $type)
            ->where('status', true)
            ->first();

        if (!$modal instanceof Modal) {
            throw new NotFoundHttpException("Modal of $type not found");
        }

        /** @var User $user */
        $user = Auth::user();
        $reaction = DB::table('inside_reactions')
            ->where('type', 'modal')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $modal->uuid)
            ->first();

        return response()->json(['reacted' => $reaction !== null]);
    }

    public function post(string $type): JsonResponse
    {
        $modal = Modal::where('modal_type', $type)
            ->where('status', true)
            ->first();

        if (!$modal instanceof Modal) {
            throw new NotFoundHttpException("Modal of $type not found");
        }

        /** @var User $user */
        $user = Auth::user();

        $reaction = DB::table('inside_reactions')
            ->where('type', 'modal')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $modal->uuid)
            ->first();

        if ($reaction === null) {
            $reaction = Reactions::create([
                'user_uuid' => $user->uuid,
                'reactionable_uuid' => $modal->uuid,
                'reactionable_type' => Modal::class,
                'type' => 'modal',
                'langcode' => $modal->langcode,
            ]);
        }

        return response()->json(['reacted' => $reaction !== null]);
    }
}
