<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddUsersTitles extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('users_titles');
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            'users',
            'users_titles',
            [
                'name' => 'users_titles',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'title' => [
                    'fr' => 'Titre utilisateur',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['users_titles'],
                    'cardinality' => 1,
                ],
            ],
        );
        $this->finishUp();
    }
}
