<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\PagesCategoriesBusiness;
use Inside\Host\Migrations\CreateContentTypes;

class AddModalContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('modal');

        $bridgeContent = new BridgeContent();
        $bridgeContent->contentInsert('modal', [
            'title' => 'Modale de bienvenue',
            'modal_type' => 'welcome',
        ]);

        $this->finishUp();
    }
}
