<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'business_offers',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Offres commerciales',
            'en' => 'Offres commerciales',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Image principale',
                'en' => 'Image principale',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'chapo',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
            ],
            'description' => [
                'fr' => 'L\'introduction remonte sur les pages de listing d\'actualité et n\'est pas dupliquée dans votre contenu',
                'en' => 'L\'introduction remonte sur les pages de listing d\'actualité et n\'est pas dupliquée dans votre contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'spaces_business',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Opération commercial',
                'en' => 'Opération commercial',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['spaces_business'],
                'cardinality' => 1,
            ],
        ],
    ],
];
