<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => 'newsletter_',
    ],
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/cuis-back/resources/assets/img/logo.png',
    ],
    'banner' => [
        'backgroundColor' => '#B78F6F',
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_intro',
    ],
    'sections' => [
        'news' => [
            'sectionType' => 'news',
            'types' => ['news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#B78F6F',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#B78F6F',
            ],
        ],
        'events' => [
            'sectionType' => 'events',
            'types' => ['events'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#B78F6F',
            'link' => [
                'sectionLinkUrl' => 'evenements',
                'sectionTextColor' => '#B78F6F',
            ],
        ],
        'documents' => [
            'sectionType' => 'documents',
            'types' => ['documents'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => false,
            'defaultCategoryColor' => '#B78F6F',
            'link' => [
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#B78F6F',
            ],
        ],
        'spaces_business' => [
            'sectionType' => 'news',
            'types' => ['spaces_business'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => false,
            'showIntroduction' => false,
            'link' => [
                'sectionLinkUrl' => 'operations-commerciales',
                'sectionTextColor' => '#B78F6F',
            ],
            'fieldLabel' => [
                'newsletter_spaces_business' => [
                    'fr' => 'Opération Commerciale du mois'
                ]
            ]
        ],
        'forms' => [
            'sectionType' => 'titles',
            'types' => ['forms'],
            'sorts' => ['published_at:desc'],
        ],
        'spaces_pages' => [
            'sectionType' => 'titles',
            'types' => ['spaces_pages'],
            'sorts' => ['title:asc'],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#B78F6F',
        'links' => [
            'youtube' => [
                'url' => '#',
            ],
            'linkedin' => [
                'url' => '#',
            ],
            'instagram' => [
                'url' => '#',
            ],
        ],
    ],
];
