<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\PagesCategoriesBusiness;
use Inside\Content\Models\Contents\PagesCategories;

class SetPagesCategoriesBusinessAsSluggable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->updateContentTypeOptions('pages_categories_business', [
            'aliasable' => true,
        ]);

        $pagesCategoriesBusiness = PagesCategoriesBusiness::all();
        foreach ($pagesCategoriesBusiness as $pageCategory) {
            $pageCategory->save();
        }

        $pagesCategories = PagesCategories::all();
        foreach ($pagesCategories as $category) {
            $category->save();
        }
    }
}
