<?php

return [
    'types'  => [
        'news'      => [
            'category' => 'news_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'documents' => [
            'category' => 'folders',
            'comments' => false,
            'likes'    => false,
        ],
        'events'    => [
            'category' => 'events_categories',
            'comments' => true,
            'likes'    => false,
        ],
        'spaces'    => [
            'category' => 'spaces_pages',
            'comments' => false,
            'likes'    => false,
        ],
        'spaces_business'    => [
            'category' => 'business_offers',
            'comments' => false,
            'likes'    => false,
        ],
        'simple_spaces'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'forms'    => [
            'category' => null,
            'comments' => true,
            'likes'    => true,
        ],
        'modal'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'tools'    => [
            'category' => 'tools_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'spaces_pages'    => [
            'category' => 'pages_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'spaces_pages_business'    => [
            'category' => 'pages_categories_business',
            'comments' => false,
            'likes'    => false,
        ],
        'pages'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
    ],
    'export' => [
        'contents'       => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL').'/edit/'.class_to_type($model).'/'.$model->uuid;
                },
            ],
        ],
        'users'          => [
            'headers' => [
                'email'     => 'Mail address',
                'full_name' => 'Full name',
            ],
        ],
        'user_visits' => [
            'headers'    => [],
        ],
        'authentication' => [
            'headers' => [],
        ],
    ],
];
