import SpacePage from '../pages/spaces/SpacePage'
import SimpleSpacePage from '../pages/spaces/SimpleSpacePage'
import TabSpacePage from '../pages/spaces/TabSpacePage'
import { fetchSpace, fetchSimpleSpace } from '../components/spaces/fetch'

import ProjectPage from '../pages/projects/ProjectPage'
import { fetchProject } from '../components/projects/fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/news/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,

      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          sort: 'weight:asc'
        },
        fields: [...folderContents.folders.fields]
      }
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/users/DirectoryPage')
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'SpacesListingPage',
    component: () => import('../pages/spaces/SpacesListingPage'),
    path: {
      fr: '/espaces',
      nl: '/afdelingen'
    }
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: {
      fr: '/espaces/:slug',
      nl: '/afdelingen/:slug'
    },
    meta: { content: 'spaces' }
  },
  {
    name: 'TabSpacePage',
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchSpace
    ),
    path: {
      fr: '/espaces/pages/:slug',
      nl: '/afdelingen/paginas/:slug'
    },
    alias: ['/fr/espaces/:slug/pages', '/en/afdelingen/:slug/paginas'],
    meta: { content: 'spaces' }
  },
  {
    name: 'SimpleSpacePage',
    component: withFetch(SimpleSpacePage, { size: 'xxl', watch: true })(
      fetchSimpleSpace
    ),
    path: {
      fr: '/espaces-simples/:slug',
      nl: '/enkele-ruimten/:slug'
    },
    meta: { content: 'simple_spaces' }
  },
  {
    name: 'ProjectsListingPage',
    component: () => import('../pages/projects/ProjectsListingPage'),
    path: {
      fr: '/projets',
      nl: '/projecten'
    }
  },
  {
    name: 'ProjectPage',
    component: withFetch(ProjectPage, { size: 'xxl', watch: true })(
      fetchProject
    ),
    path: {
      fr: '/projets/:slug',
      nl: '/projecten/:slug'
    }
  },
  {
    name: 'OffersListingPage',
    component: () => import('../pages/offers/OffersListingPage'),
    path: {
      fr: '/petites-annonces',
      nl: '/rubrieksadvertenties'
    }
  },
  {
    name: 'JobsListingPage',
    component: () => import('../pages/jobs/JobsListingPage')
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
