import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  spacesCategories: {
    add: async ({ data }) => {
      const { data: spaceCategories } = await http.get(
        'content/spaces_categories',
        {
          fields: [
            'uuid',
            'slug',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: spaceCategories[0].spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spaceCategories } = await http.get(
        'content/spaces_categories',
        {
          fields: [
            'uuid',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: spaceCategories[0].spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/spaces_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: pagesCategories[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            spaces_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].spaces_categories.spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            spaces_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].spaces_categories.spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            spaces_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })


      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: spacesPages[0].spaces_categories.spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  simpleSpaces: {
    add: ({ data }) => ({
      name: 'SimpleSpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  projects: {
    add: ({ data }) => ({
      name: 'ProjectPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  simpleSpacesCategories: {
    add: async ({ data }) => {
      const { data: spaceCategories } = await http.get(
        'content/simple_spaces_categories',
        {
          fields: [
            'uuid',
            'slug',
            {
              simple_spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'SimpleSpacePage',
        params: {
          slug: spaceCategories[0].simple_spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spaceCategories } = await http.get(
        'content/simple_spaces_categories',
        {
          fields: [
            'uuid',
            {
              simple_spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'SimpleSpacePage',
        params: {
          slug: spaceCategories[0].simple_spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data, vm }) => {
      const { data: pagesCategories } = await http.get(
        'content/simple_spaces_categories',
        {
          fields: ['uuid', { simple_spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'SimpleSpacePage',
          params: {
            slug: pagesCategories[0].simple_spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  simpleSpacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get(
        'content/simple_spaces_pages',
        {
          fields: [
            'uuid',
            'slug',
            {
              simple_spaces_categories: [
                'uuid',
                'title',
                {
                  simple_spaces: {
                    fields: ['uuid', 'title', 'slug']
                  }
                }
              ]
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'SimpleSpacePage',
        params: {
          slug: spacesPages[0].simple_spaces_categories.simple_spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get(
        'content/simple_spaces_pages',
        {
          fields: [
            'uuid',
            'title',
            {
              simple_spaces_categories: [
                'uuid',
                'title',
                {
                  simple_spaces: {
                    fields: ['uuid', 'title', 'slug']
                  }
                }
              ]
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'SimpleSpacePage',
        params: {
          slug: spacesPages[0].simple_spaces_categories.simple_spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data, vm }) => {
      const { data: spacesPages } = await http.get(
        'content/simple_spaces_pages',
        {
          fields: [
            'uuid',
            'title',
            {
              simple_spaces_categories: [
                'uuid',
                'title',
                {
                  simple_spaces: {
                    fields: ['uuid', 'title', 'slug']
                  }
                }
              ]
            }
          ],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'SimpleSpacePage',
          params: {
            slug:
              spacesPages[0].simple_spaces_categories.simple_spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  projectStatus: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  classifiedsCategories: {
    add: () => ({
      name: 'OffersListingPage'
    }),
    delete: () => ({
      name: 'OffersListingPage'
    })
  },
  classifieds: {
    add: () => ({
      name: 'OffersListingPage'
    }),
    delete: () => ({
      name: 'OffersListingPage'
    }),
    globalSearch: ({ data, vm }) => ({
      action: () => {
        vm.triggerModal(
          'offer',
          'fetch',
          {
            item: data,
            contentType: data.contentType
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
      }
    })
  },
  projectDocuments: {
    add: async ({ data }) => {
      try {
        const { data: project } = await http.get('content/project_documents', {
          fields: [
            'uuid',
            'title',
            { project_folders: ['uuid', { projects: ['uuid', 'slug'] }] }
          ],
          filters: { 'uuid:eq': data.uuid }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: project[0].project_folders.projects.slug[0]
          },
          query: {
            folder: project[0].project_folders.uuid
          }
        }
      } catch (err) {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: project } = await http.get('content/project_documents', {
          fields: [
            'uuid',
            { project_folders: ['uuid', { projects: ['uuid', 'slug'] }] }
          ],
          filters: { 'status:eq': 1, 'uuid:eq': uuid }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: project[0].project_folders.projects.slug[0]
          },
          query: {
            folder: project[0].project_folders.uuid
          }
        }
      } catch (err) {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    globalSearch: async ({ data, vm }) => {
      const { data: projectDoc } = await http.get('content/project_documents', {
        fields: [
          'uuid',
          'title',
          {
            project_folders: [
              'uuid',
              'title',
              {
                projects: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'ProjectPage',
          params: {
            slug: projectDoc[0].project_folders.projects.slug[0]
          },
          query: { folder: projectDoc[0].project_folders.uuid }
        }
      }
    }
  },
  projectFolders: {
    add: async ({ data }) => {
      try {
        const { data: project } = await http.get('content/project_folders', {
          fields: [
            'uuid',
            'title',
            { project_folders: ['uuid', { projects: ['uuid', 'slug'] }] },
            { projects: ['uuid', 'slug'] }
          ],
          filters: { 'uuid:eq': data.uuid }
        })

        if (project.project_folders) {
          const { data: projectFolder } = await http.get(
            'content/project_folders',
            {
              fields: [
                'uuid',
                'title',
                {
                  projects: ['uuid', 'title', 'slug']
                }
              ],
              filters: { 'uuid:eq': project.project_folders.uuid }
            }
          )

          return {
            name: 'ProjectPage',
            params: { slug: projectFolder[0].projects.slug[0] }
          }
        }

        if (project[0].projects) {
          const { data: projectData } = await http.get('content/projects', {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'uuid:eq': project[0].projects.uuid }
          })

          return {
            name: 'ProjectPage',
            params: { slug: projectData[0].slug[0] }
          }
        }
      } catch (err) {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/project_folders', {
          fields: ['uuid', { projects: ['uuid', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': uuid }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: data[0].projects.slug[0]
          }
        }
      } catch (err) {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    globalSearch: async ({ data, vm }) => {
      const { data: projectDoc } = await http.get('content/project_folders', {
        fields: [
          'uuid',
          'title',

          {
            projects: {
              fields: ['uuid', 'title', 'slug']
            }
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'ProjectPage',
          params: {
            slug: projectDoc[0].projects.slug[0]
          },
          query: { folder: data.uuid }
        }
      }
    }
  },
  jobOffers: {
    add: () => ({ name: 'JobsListingPage' }),
    delete: () => ({ name: 'JobsListingPage' }),
    globalSearch: ({ data, vm }) => ({
      action: () => {
        vm.triggerModal(
          'job-offers',
          'fetch',
          {
            item: data,
            contentType: data.contentType
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
      }
    })
  },
  contractType: {
    add: () => ({ name: 'JobsListingPage' }),
    delete: () => ({ name: 'JobsListingPage' })
  }
}
