import RatioImageUi from '@inside-ui/RatioImageUI'
import { BaseText } from 'inside-collection/atoms'

export default {
  components: { RatioImageUi, BaseText },
  props: {
    content_type: {
      type: String
    }
  },
  data() {
    return {
      m_categoriesConfig: {
        classifieds_categories: {
          data: (data, contentType, { getData }) => {
            return getData(data, contentType)
          },
          style: 'tag',
          disabledOn: ['OffersListingPage'],
          href: item => ({
            name: 'OffersListingPage',
            query: { classifieds_categories: item.uuid }
          })
        }
      }
    }
  },
  methods: {
    m_capsuleOverrides(data, { deleteItems, addItemBefore }) {
      deleteItems('bookmarks', 'date')

      addItemBefore('categories', {
        id: 'date',
        tag: 'date-ui',
        class: 'capsule-date mb-xs',
        data: { date: data.published_at }
      })
    },
    m_fullOverrides(data, { deleteItems }) {
      deleteItems(
        'bottom-actions',
        'bookmarks',
        'likes',
        'statistics',
        'comments',
        'print'
      )
    }
  }
}
