export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-news': {
    bookmarkEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-ged': {
    useBookmarks: true
  },
  'inside-jobs': {
    mainContentType: 'job_offers',
    modalName: 'job-offers',
    extraFields: [
      'uuid',
      'title',
      'admin',
      'content_type',
      'end_date',
      'content',
      { contract_type: ['uuid', 'title'] },
      { workplaces: ['uuid', 'title'] },
      { departments: ['uuid', 'title', 'color'] }
    ],
    categoriesFields: [
      {
        workplaces: {
          fields: ['uuid', 'title'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        departments: {
          fields: ['uuid', 'title', 'color'],
          filters: { 'status:eq': 1 }
        }
      }
    ]
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          'function',
          'mobile_phone'
        ]
      }
    }
  },
  'inside-workflows': {
    isEnabled: true
  }
}
