import { http } from '@inside-library/helpers/Http'

const fetchImagesBlocks = async () => {
  try {
    const { data } = await http.get('content/blocks', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'link',
        'admin',
        'content_type',
        'visible_homepage'
      ],
      filters: {
        'status:eq': 1,
        visible_homepage: 1,
        sort: 'weight:asc',
        limit: 3
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchImagesBlocks }
