export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'function',
      'email',
      'image',
      'phone',
      'mobile_phone',
      'biography',
      'workplaces',
      'departments',
      'managers'
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  project_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  classifieds: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'published_at',
      'content',
      'image',
      { classifieds_categories: ['title', 'uuid', 'color'] }
    ]
  },
  jobOffers: {
    modalFields: [
      'uuid',
      'title',
      'admin',
      'content_type',
      'end_date',
      'content',
      { contract_type: ['uuid', 'title'] },
      { workplaces: ['uuid', 'title'] },
      { departments: ['uuid', 'title'] }
    ]
  }
}
