<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

final class RemoveNewsCategoriesFieldFromFormsType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (Schema::hasModel('forms') && Schema::hasField('forms', 'news_categories')) {
            $bridge->contentTypeDeleteField('node', 'forms', 'news_categories');
        }
    }
}
