<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => '',
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/cpas-back/resources/assets/img/newsletter/banner.jpg',
        'backgroundColor' => '#fff',
        'bannerWidth' => 700,
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_intro',
        'textColor' => '#2C3E50',
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'sectionType' => 'news',
            'types' => ['news'],
            'fieldLabel' => [
                'news' => [
                    'fr' => 'Actualités à la une',
                    'nl' => 'Nieuws',
                ],
            ],
            'sorts' => ['date:desc'],
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#4DBAB3',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#4DBAB3',
                'sectionLinkStrKey' => 'newsletter.news_link',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'fieldLabel' => [
                'events' => [
                    'fr' => 'Événements',
                    'nl' => 'Evenementen',
                ],
            ],
            'sorts' => ['date:desc'],
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#4DBAB3',
            'link' => [
                'sectionLinkUrl'   => 'evenements',
                'sectionTextColor' => '#4DBAB3',
                'sectionLinkStrKey' => 'newsletter.see_all_events',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'fieldLabel' => [
                'documents' => [
                    'fr' => 'Documents',
                    'nl' => 'Documenten',
                ],
            ],
            'sorts' => ['published_at:desc'],
            'imageStyle' => 'medium',
            'leftLineColor' => '#4DBAB3',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'mediatheque',
                'sectionTextColor' => '#4DBAB3',
            ],
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#F0F0F0',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning',
    ],
];
