<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddCodeFieldsToReferences extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $bridgeContentType = new BridgeContentType();
        collect(['departments','workplaces'])
            ->each(
                fn ($contentType) =>
                $bridgeContentType->contentTypeCreateOrUpdateField($contentType, 'code', [
                    'name' => 'code',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 1,
                    'title' => [
                        'fr' => 'Référence d\'import',
                        'nl' => 'Reference'
                    ],
                    'widget' => [
                        'hidden' => true,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ]
                ])
            );

        $this->finishUp();

        Artisan::call('models:rebuild');

        $bridgeContent = new BridgeContent();

        type_to_class('departments')::query()
            ->whereNull('code')
            ->pluck('title', 'uuid')
            ->each(fn ($title, $uuid) => $bridgeContent->contentUpdate('departments', [
                'uuid' => $uuid,
                'code' => $title
            ]));

        type_to_class('workplaces')::query()
            ->whereNull('code')
            ->pluck('title', 'uuid')
            ->each(fn ($title, $uuid) => $bridgeContent->contentUpdate('workplaces', [
                'uuid' => $uuid,
                'code' => $title
            ]));
    }
}
