<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixContentForNetherlands extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('project_status', false);
        $this->migrateContent('contract_type', false);
        $this->finishUp();

        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeUpdate('movements', [
            'title' => [
                'fr' => 'Mouvements',
                'en' => 'Movements',
                'nl' => 'Bewegingen',
            ],
        ]);

        $bridgeContentType->contentTypeUpdate('movements_categories', [
            'title' => [
                'fr' => 'Catégorie de mouvement',
                'en' => 'Movement category',
                'nl' => 'Bewegingscategorie',
            ],
        ]);

        $bridgeContentType->contentTypeUpdate('years', [
            'title' => [
                'fr' => 'Année',
                'en' => 'Year',
                'nl' => 'Jaar',
            ],
        ]);

        $bridgeContentType->contentTypeUpdate('organization_items', [
            'title' => [
                'fr' => 'Utilisateur organigramme',
                'en' => 'Organization chart user',
                'nl' => 'Organigram gebruiker',
            ],
        ]);

        $bridgeContentType->contentTypeUpdate('organizations', [
            'title' => [
                'fr' => 'Organigramme',
                'en' => 'Organization chart',
                'nl' => 'Organigram',
            ],
        ]);

        $bridgeContentType->contentTypeUpdate('organizations_categories', [
            'title' => [
                'fr' => 'Catégorie d\'organigramme',
                'en' => 'Organization chart category',
                'nl' => 'Organigramcategorie',
            ],
        ]);
    }
}
