<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\MovementsCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AlterContentForNetherlands extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('dms_link', false);
        $this->migrateContent('external_notifications', false);
        $this->finishUp();

        $bridgeContentType = new BridgeContentType();

        /**
         *  MOVEMENTS
         */
        $bridgeContentType->updateFieldOptions('movements', 'movements_users', [
            'title' => [
                'fr' => 'Utilisateur',
                'en' => 'User',
                'nl' => 'Gebruiker',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('movements', 'movements_categories', [
            'title' => [
                'fr' => 'Catégorie',
                'en' => 'Category',
                'nl' => 'Categorie',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('movements', 'movements_description', [
            'title' => [
                'fr' => 'Description',
                'en' => 'Description',
                'nl' => 'Beschrijving',
            ],
        ]);


        /**
         *  MOVEMENTS_CATEGORIES
         */
        $bridgeContentType->updateFieldOptions('movements_categories', 'color', [
            'title' => [
                'fr' => 'Couleur',
                'en' => 'Color',
                'nl' => 'Kleur',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('movements_categories', 'button_text', [
            'title' => [
                'fr' => 'Texte du bouton',
                'en' => 'Button Text',
                'nl' => 'Knoptekst',
            ],
        ]);


        /**
         *  ORGANIZATION_ITEMS
         */
        $bridgeContentType->updateFieldOptions('organization_items', 'organizations', [
            'title' => [
                'fr' => 'Organigramme',
                'en' => 'Organization chart',
                'nl' => 'Organigram',
            ],
            'description' => [
                'fr' => 'Choix de l\'organigramme dans lequel l\'utilisateur doit remonter',
                'en' => 'Choice of the organization chart in which the user must go up',
                'nl' => 'Keuze van het organigram waarin de gebruiker moet opkomen',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organization_items', 'organization_items', [
            'title' => [
                'fr' => 'Manager',
                'en' => 'Manager',
                'nl' => 'Manager',
            ],
            'description' => [
                'fr' => 'Choix du manager de l\'utilisateur. Si non coché alors l\'utilisateur se place en haut de l\'organigramme',
                'en' => 'Choice of the user\'s manager. If not checked then the user is placed at the top of the organization chart',
                'nl' => 'Keuze van de manager van de gebruiker. Indien niet aangevinkt, wordt de gebruiker bovenaan het organigram geplaatst',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organization_items', 'users', [
            'title' => [
                'fr' => 'Utilisateur',
                'en' => 'User',
                'nl' => 'Gebruiker',
            ],
            'description' => [
                'fr' => 'Choix de l\'utilisateur de l\'intranet. Si ce champ est complété il prend la main sur les champs suivants',
                'en' => 'Choice of the intranet user. If this field is completed it takes precedence over the following fields',
                'nl' => 'Keuze van de intranetgebruiker. Als dit veld is ingevuld, heeft het voorrang op de volgende velden',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organization_items', 'image', [
            'title' => [
                'fr' => 'Photo utilisateur',
                'en' => 'User photo',
                'nl' => 'Gebruikersfoto',
            ],
            'description' => [
                'fr' => 'Si l\'utilisateur n\'est pas un utilisateur de l\'intranet',
                'en' => 'If the user is not an intranet user',
                'nl' => 'Als de gebruiker geen intranetgebruiker is',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organization_items', 'function', [
            'title' => [
                'fr' => 'Fonction utilisateur',
                'en' => 'User function',
                'nl' => 'Gebruikersfunctie',
            ],
            'description' => [
                'fr' => 'Si l\'utilisateur n\'est pas un utilisateur de l\'intranet',
                'en' => 'If the user is not an intranet user',
                'nl' => 'Als de gebruiker geen intranetgebruiker is',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organization_items', 'assistants_title', [
            'title' => [
                'fr' => "Titre de l'adjoint / assistant",
                'en' => 'Assistant / Deputy Title',
                'nl' => 'Assistent / Plaatsvervangende titel',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organization_items', 'assistants', [
            'title' => [
                'fr' => 'Assistant(e) ou adjoint(e)',
                'en' => 'Assistant or deputy',
                'nl' => 'Assistent of plaatsvervanger',
            ],
            'description' => [
                'fr' => "Définir l'adjoint(e) ou l'assistant(e) de l'utilisateur",
                'en' => 'Set the user\'s assistant or deputy',
                'nl' => 'Stel de assistent of plaatsvervanger van de gebruiker in',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organization_items', 'weight', [
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'nl' => 'Weergavevolgorde',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up first',
                'nl' => 'Het laagste nummer gaat eerst omhoog',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organization_items', 'is_empty', [
            'title' => [
                'fr' => 'Bloc invisible',
                'en' => 'Invisible block',
                'nl' => 'Onzichtbaar blok',
            ],
        ]);


        /**
         *  ORGANIZATIONS
         */
        $bridgeContentType->updateFieldOptions('organizations', 'organizations_categories', [
            'title' => [
                'fr' => 'Catégorie d\'organigramme',
                'en' => 'Organization chart category',
                'nl' => 'Organigramcategorie',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organizations', 'organization_intro', [
            'title' => [
                'fr' => 'Catégorie d\'organigramme',
                'en' => 'Organization chart category',
                'nl' => 'Organigramcategorie',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organizations', 'image', [
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'nl' => 'Afbeelding',
            ],
        ]);

        $bridgeContentType->updateFieldOptions('organizations', 'weight', [
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'nl' => 'Weergavevolgorde',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up first',
                'nl' => 'Het laagste nummer gaat eerst omhoog',
            ],
        ]);


        /**
         *  ORGANIZATIONS CATEGORIES
         */
        $bridgeContentType->updateFieldOptions('organizations_categories', 'weight', [
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'nl' => 'Weergavevolgorde',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up first',
                'nl' => 'Het laagste nummer gaat eerst omhoog',
            ],
        ]);


        /**
         *  ENTITIES MOVEMENTS_CATEGORIES
         */
        $bridge = new BridgeContent();

        $nomination = MovementsCategories::where(['template' => 'nomination', 'langcode' => 'nl'])->first();

        if ($nomination) {
            $bridge->contentUpdate('movements_categories', [
                'uuid' => $nomination->uuid,
                'title' => 'Afspraak',
                'button_text' => 'Gefeliciteerd',
            ]);
        }

        $arrival = MovementsCategories::where(['template' => 'arrival', 'langcode' => 'nl'])->first();

        if ($arrival) {
            $bridge->contentUpdate('movements_categories', [
                'uuid' => $arrival->uuid,
                'title' => 'Aankomst',
                'button_text' => 'Welkom',
            ]);
        }
    }
}
