<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Utilisateur',
            'nl' => 'Gebruiker',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Photo de profil',
                'nl' => 'Profielfoto',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'firstname',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Prénom',
                'nl' => 'Voornaam',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'lastname',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Nom',
                'nl' => 'Naam',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'phone',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Téléphone',
                'nl' => 'Telefoon',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_PHONE_WIDGET,
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'mobile_phone',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Mobile',
                'nl' => 'Mobiel',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_PHONE_WIDGET,
                'weight' => 5,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'workplaces',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Site',
                'nl' => 'Site',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['workplaces'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'departments',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Département',
                'nl' => 'Afdeling',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 7,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['departments'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'tools',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Accès rapides',
                'nl' => 'Snelle toegang',
            ],
            'widget' => [
                'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                'settings' => [],
                'weight' => 8,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tools'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'is_maintenance',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 9,
            'title' => [
                'fr' => 'Compte de maintenance ?',
                'nl' => 'Onderhoudsaccount?',
            ],
            'description' => [
                'fr' => 'Si cette case est cochée l\'utilisateur ne remontera pas dans l\'annuaire de l\'intranet',
                'nl' => 'Als dit vakje is aangevinkt, gaat de gebruiker niet omhoog in de intranet -directory',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 9,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'send_mail',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Envoyer un mail à la création de mot de passe',
                'nl' => 'Stuur een e -mail naar het maken van wachtwoord',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'is_gdpr_compliant',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 11,
            'title' => [
                'fr' => 'RGPD Compliant',
                'nl' => 'Complant GDPR',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 11,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'biography',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'editable' => true,
            'weight' => 12,
            'title' => [
                'fr' => 'Biographie',
                'nl' => 'Biografie',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 3,
                'group' => 'group_contact',
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
