<?php

use Adldap\Models\Entry;

return [
    'usernames' => [
        'ldap' => [
            'discover' => env('ADLDAP_LDAP_DISCOVER', 'samaccountname'),
            'authenticate' => env('ADLDAP_LDAP_AUTHENTICATE', 'userprincipalname'),
        ],
        'eloquent' => env('ADLDAP_ELOQUENT_VALUE', 'name'),
    ],
    'discovering_attributes' => 'name',
    'sync_attributes' => [
        'email' => 'mail',
        'name' => 'samaccountname',
        'firstname' => 'givenname',
        'lastname' => 'sn',
        'cn' => 'cn',
        'upn' => 'userprincipalname',
        'function' => 'title',
        'phone' => 'telephonenumber',
        'mobile_phone' => 'mobile',
        'internal_phone' => 'othertelephone',
        'managers' => function (Entry $user) {
            if (blank($user->getAttribute('manager')) || !is_string($user->getAttribute('manager')[0])) {
                return null;
            }

            $cn = str($user->getAttribute('manager')[0])
                ->after('CN=')
                ->before(',')
                ->toString();

            return reference('users')
                ->identifiedBy('cn')
                ->from($cn)
                ->withoutCreation()
                ->first();
        },
        'departments' => fn (Entry $user) => reference('departments')
            ->identifiedBy('code')
            ->from($user->getAttribute('department')[0])
            ->get(),
        'workplaces' => fn (Entry $user) => reference('workplaces')
            ->identifiedBy('code')
            ->from($user->getAttribute('streetAddress')[0])
            ->get(),
    ]
];
