import { withFetch } from 'inside-collection/hocs'

import RhSpacePage from '../pages/space/RhSpacePage'
import { fetchRhSpacePage } from '../components/space/fetch'

import AgendaRoomsListingPage from '../pages/agenda/AgendaRoomsListingPage'
import {
  fetchServicesAndDemands,
  fetchServices,
  fetchAgendaRoomsListingPage
} from '../fetch'

import ServiceContactPage from '../pages/service-contact/ServiceContactPage'
import ServiceContactAdminPage from '../pages/service-contact/ServiceContactAdminPage'
import { serviceContactGuard, homeRedirectionGuard } from '../guards'

import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    path: '/home',
    name: 'HomeRedirection',
    component: () => import('../pages/HomeRedirectionPage'),
    meta: { middleware: homeRedirectionGuard }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/news/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    path: '/evenements',
    name: 'EventListingPage',
    component: () => import('../pages/events/EventListingPage')
  },
  {
    name: 'EventPage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/DirectoryPage')
  },
  {
    path: '/pages/:slug',
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'JobsListingPage',
    component: () => import('../pages/JobsListingPage')
  },
  {
    path: '/espace/:slug',
    name: 'RhSpacePage',
    component: withFetch(RhSpacePage, { size: 'xxl' })(fetchRhSpacePage)
  },
  {
    path: '/espace/:slug/bibliotheque',
    name: 'RhSpaceGedPage',
    component: () => import('../pages/space/RhSpaceGedPage')
  },
  {
    name: 'AgendaListingPage',
    component: () => import('../pages/agenda/AgendaListingPage'),
    meta: { disabled: false }
  },
  {
    path: '/reservations-de-salles/:slug',
    name: 'AgendaRoomsListingPage',
    component: withFetch(AgendaRoomsListingPage, { size: 'xxl' })(
      fetchAgendaRoomsListingPage
    )
  },
  {
    name: 'AgendaPage',
    component: () => import('../pages/agenda/AgendaPage'),
    meta: { disabled: false }
  },
  {
    path: '/contact-service',
    name: 'ServiceContact',
    component: withFetch(ServiceContactPage, { size: 'xxl' })(
      fetchServicesAndDemands
    )
  },
  {
    path: '/contact-service/reponses',
    name: 'ServiceContactAdmin',
    component: withFetch(ServiceContactAdminPage, { size: 'xxl' })(
      fetchServices
    ),
    meta: {
      middleware: serviceContactGuard
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      gridMinMax: '250',
      cardSize: 's',
      cardOverlayEnabled: false
    }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
