import { http } from '@inside-library/helpers/Http'
import get from 'lodash/get'

export default {
  events: {
    add: ({ data }) => ({
      name: 'EventPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'EventListingPage' })
  },
  eventsCategories: {
    add: () => ({ name: 'EventListingPage' }),
    delete: () => ({ name: 'EventListingPage' })
  },
  rhSpaces: {
    add: ({ data }) => ({
      name: 'RhSpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'RhSpacePage' })
  },
  rhFolders: {
    add: async ({ data }) => {
      try {
        const { data: uuidSpaces } = await http.get('content/rh_folders', {
          fields: ['uuid', { rh_spaces: { fields: ['uuid', 'slug'] } }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'RhSpaceGedPage',
          params: {
            slug: uuidSpaces[0].rh_spaces.slug[0]
          },
          query: { folder: data.uuid }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: () => ({ name: 'RhSpaceGedPage' }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  rhDocuments: {
    add: async ({ data }) => {
      const { data: document } = await http.get('content/rh_documents', {
        fields: [
          'uuid',
          { rh_folders: ['uuid', { rh_spaces: ['uuid', 'slug'] }] }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'RhSpaceGedPage',
        params: {
          slug: document[0].rh_folders.rh_spaces.slug[0]
        },
        query: { folder: document[0].rh_folders.uuid }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/rh_documents', {
          fields: [
            {
              rh_folders: {
                fields: ['uuid', 'title'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        const folder =
          get(data, [0, 'rh_folders', 'uuid']) ||
          get(data, [0, 'rh_folders', 'data', 0, 'uuid'])

        return {
          name: 'RhSpaceGedPage',
          query: { folder }
        }
      } catch (err) {
        return { name: 'RhSpaceGedPage' }
      }
    },
    globalSearch: ({ data, vm }) => ({
      action: () =>
        vm.triggerModal(
          'doc-ged',
          'fetch',
          {
            item: data,
            contentType: data.contentType
          },
          { layout: 'right', size: 'l', transition: 'fadeInLeft' }
        )
    })
  },
  cities: {
    add: () => ({ name: 'AgendaListingPage' }),
    delete: () => ({ name: 'AgendaListingPage' })
  },
  rooms: {
    fields: [
      { cities: { fields: ['uuid', 'slug'], filters: { reverse: true } } }
    ],
    add: ({ data }) => {
      try {
        return {
          name: 'AgendaRoomsListingPage',
          params: { slug: data.cities.data[0].slug[0] }
        }
      } catch (err) {
        return { name: 'AgendaListingPage' }
      }
    },
    delete: ({ data }) => {
      try {
        return {
          name: 'AgendaRoomsListingPage',
          params: { slug: data.cities.data[0].slug[0] }
        }
      } catch (err) {
        return { name: 'AgendaListingPage' }
      }
    }
  },
  services: {
    add: () => ({ name: 'ServiceContact' }),
    delete: () => ({ name: 'ServiceContact' })
  },
  requestTypes: {
    add: () => ({ name: 'ServiceContact' }),
    delete: () => ({ name: 'ServiceContact' })
  },
  cardsLinks: {
    add: () => ({ name: 'HomePage' }),
    delete: () => ({ name: 'HomePage' })
  }
}
