import { http } from '@inside-library/helpers/Http'
import { formatHref } from '@inside-library/helpers/Langs'

const serviceContactGuard = async ({ to, store, next }) => {
  let routeName = 'ServiceContact'

  if (to.name.includes('ServiceContactAdmin')) {
    try {
      const { data } = await http.get('content/services', {
        filters: {
          'status:eq': 1,
          sort: 'title:asc',
          contact_accounts: {
            'uuid:eq': store.getters.getUserInfos.uuid
          }
        },
        fields: [{ contact_accounts: ['uuid'] }]
      })

      if (data.length) {
        routeName = null
      }
    } catch (err) {
      throw new Error(err)
    }

    if (!routeName) {
      next()
    } else {
      next(
        formatHref(
          {
            name: routeName
          },
          store.getters.getCurrentLang
        )
      )
    }
  }

  next()
}

const homeRedirectionGuard = async ({ router }) => {
  router.push('/')
}

export { serviceContactGuard, homeRedirectionGuard }
