import { http } from '@inside-library/helpers/Http'

export const fetchRhSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/rh_spaces', {
      filters: { slug: $route.params.slug },
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'image',
        'admin',
        {
          key_contacts: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'functions',
              'phone',
              { branches: ['uuid', 'title'] },
              'shortcuts'
            ],
            filters: {
              'status:eq': 1,
              limit: 4
            }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'introduction',
                    'chapo',
                    'published_at',
                    'updated_at',
                    'image',
                    'content_type',
                    {
                      news_categories: [
                        'uuid',
                        'title',
                        'color',
                        'slug',
                        'content_type'
                      ]
                    },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    'published_at:lte': 'now()',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()'
            }
          }
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
