export default {
  users: {
    modalFields: [
      'uuid',
      'image',
      'firstname',
      'lastname',
      'functions',
      'linkedin',
      'expertises',
      'email',
      'phone',
      'mobile',
      'shortcuts',
      'branches',
      'offices',
      'languages'
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  rh_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { rh_folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  jobs_offers: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'link',
      'button_link',
      'content',
      { contracts_types: ['uuid', 'title'] },
      { branches: ['uuid', 'title'] }
    ]
  },
  contact_services: {
    modalFields: [
      'uuid',
      'title',
      'object',
      'message',
      'file',
      'published_at',
      { services: ['title'] },
      { request_types: ['title'] },
      { authors: ['firstname', 'lastname', 'email'] }
    ]
  }
}
