import { markRaw } from 'vue'

import { IconText } from 'inside-collection/atoms'

export default {
  'inside-administration': {
    subModules: ['inside-mailings']
  },
  'inside-agenda': {
    allowedViews: ['week', 'month'],
    rootRoute: {
      fr: 'reservations'
    }
  },
  'inside-news': {
    bookmarkEnabled: false
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: false,
      useBackgroundImage: true
    },
    allowAvatarEdition: false,
    shortcuts: {
      max: 5
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'contents', restrictions: [] },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: { functions: ['title'] },
        data: data => (data.functions || {}).title
      },
      {
        field: { branches: ['title'] },
        data: data => (data.branches || {}).title
      }
    ]
  },
  'inside-jobs': {
    extraFields: [
      { branches: { fields: ['title', 'uuid'], filters: { 'status:eq': 1 } } }
    ],
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', {
        id: 'address',
        tag: markRaw(IconText),
        class: 'address',
        data: { icon: 'address' },
        value: data?.branches?.title,
        hideIf: () => !data?.branches?.title
      })
    }
  },
  'inside-ged': {
    rootRoute: {
      fr: 'bibliotheque-de-ressources'
    }
  },
  globals: {
    notificationRedirectionsContentTypes: ['news', 'events'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      }),
      events: async ({ data }) => ({
        name: 'EventPage',
        params: {
          slug: data.slug[0]
        }
      })
    }
  }
}
