import { http } from '@inside-library/helpers/Http'

const fetchServicesAndDemands = async () => {
  try {
    const services = await http.get('content/services', {
      filters: {
        'status:eq': 1,
        sort: 'title:asc'
      },
      fields: ['title', 'uuid', { contact_accounts: ['uuid'] }]
    })

    const requestTypes = await http.get('content/request_types', {
      filters: {
        'status:eq': 1,
        sort: 'title:asc'
      },
      fields: ['title', 'uuid']
    })

    return {
      services: services.data,
      requestTypes: requestTypes.data
    }
  } catch (err) {
    throw new Error(err)
  }
}

const fetchServices = async ({ store }) => {
  try {
    const { data } = await http.get('content/services', {
      filters: {
        'status:eq': 1,
        sort: 'title:asc',
        contact_accounts: {
          'uuid:eq': store.getters.getUserInfos.uuid
        }
      },
      fields: ['title', 'uuid', { contact_accounts: ['uuid'] }]
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/pages', {
      fields: ['uuid', 'title', 'admin', 'content_type', 'content', 'banner'],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchAgendaRoomsListingPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/cities', {
      fields: [
        'title',
        'uuid',
        'admin',
        'slug',
        {
          cities_rooms: {
            fields: ['uuid', 'admin', 'content_type', 'slug', 'title', 'image'],
            filters: { 'status:eq': 1 }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export {
  fetchServicesAndDemands,
  fetchServices,
  fetchPage,
  fetchAgendaRoomsListingPage
}
