<?php

namespace Inside\CORO\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Inside\Content\Models\Contents\ContactServices;

class ContentCreatedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ContentCreatedEvent $event): void
    {
        $model = $event->model;

        if (get_class($model) === ContactServices::class) {
            /** @var ?NotificationType $type */
            $type = NotificationType::where('event', 'Inside\Content\Events\ContentCreatedEvent')
                ->where('model', 'Inside\Content\Models\Contents\ContactServices')
                ->where('action', 'create')
                ->where('type', 'system')
                ->first();

            if (!$type) {
                return;
            }

            $service = $model->services->first();
            $users = $service->contactAccounts;
            $url = 'contact-service/reponses';
            /** @var User $author */
            $author = User::find($model->author);
            $file = $model->file ? "Une pièce jointe a été soumise, cliquer sur le bouton pour la consulter" : null;

            foreach ($users as $user) {
                /** @var ?User $user */
                $user = User::find($user->uuid);
                $this->when = $this->getInterval($type);
                $this->route = $user;
                $this->notify(
                    $type,
                    $user,
                    $model,
                    [
                        "from" => $model->author,
                        "url" => $url,
                        "object" => $model->object,
                        "message" => $model->message,
                        "service" => $service->title,
                        "email" => $author->email,
                        "file" => $file
                    ]
                );
            }
        }
    }
}
