<?php

return [
    '_meta' => [
        'type' => 'newsletters'
    ],
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/coro-back/resources/assets/img/logo.png',
        'logoWidth' => 170,
        'showDate' => true,
        'dateColor' => '#a7a7a7',
        'dateFormat' => '%A %d %B %Y',
    ],
    'banner' => [
        'backgroundColor' => '#CCA876'
    ],
    'introduction' => [
    ],
    'sections' => [
        'news' => [
            'types' => ['news'],
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#02614D',
            'defaultImageUrl' => 'vendor/maecia/coro-back/resources/assets/newsletter/news-default.png',
            'dateFormat' => '%d/%m/%Y',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#02614D',
            ],
        ],
        'events' => [
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#348070',
            'link' => [
                'sectionLinkUrl' => 'evenements',
                'sectionTextColor' => '#02614D',
            ],
        ],
        'activities' => [
            'link' => null,
            'orientation' => 'horizontal',
            'items' => [
                'comments' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\Comments::count();
                    },
                    'valueColor' => '#2C3E50',
                    'backgroundColor' => '#fff',
                    'backgroundImageUrl' => 'vendor/maecia/coro-back/resources/assets/newsletter/commentaires.png',
                    'titleStrKey' => 'newsletter.comments_statistic',
                ],
                'likes' => [
                    'callback' => function () {
                        return \Inside\Reaction\Models\Reaction::where('type', 'like')->count();
                    },
                    'valueColor' => '#2C3E50',
                    'backgroundColor' => '#fff',
                    'backgroundImageUrl' => 'vendor/maecia/coro-back/resources/assets/newsletter/like.png',
                    'titleStrKey' => 'newsletter.likes_statistic',
                ],
                'users' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\Users::where('status', true)->count();
                    },
                    'valueColor' => '#2C3E50',
                    'backgroundColor' => '#fff',
                    'backgroundImageUrl' => 'vendor/maecia/coro-back/resources/assets/newsletter/utilisateurs.png',
                    'titleStrKey' => 'newsletter.users_statistic',
                ],
                'news' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\News::where('status',
                            true)->count();
                    },
                    'valueColor' => '#2C3E50',
                    'backgroundColor' => '#fff',
                    'backgroundImageUrl' => 'vendor/maecia/coro-back/resources/assets/newsletter/articles.png',
                    'titleStrKey' => 'newsletter.news_statistics',
                ],
            ],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#02614D',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/Coutot-Roehrig-G%C3%A9n%C3%A9alogistes-147018592154825',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/CoutotRoehrigSA',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/coutot-roehrig',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/coutot_roehrig',
            ],
        ],
    ],
    'footer' => [
    ],
];
