<?php

use Inside\Content\Models\Contents\RhSpaces;
use Inside\Settings\Models\Setting;
use Illuminate\Database\Migrations\Migration;

class AddedDefaultSettingsRhSpacesLink extends Migration
{
    public function up(): void
    {
        $rhSpaces = RhSpaces::query()->where('title', 'Espace RH')->first();
        if (!$rhSpaces) {
            throw new Exception('Content "Espace RH" not found !');
        }

        Setting::updateOrCreate(
            [
                'group' => 'general',
                'key' => 'job_back_space_link',
            ],
            [
                'value' => $rhSpaces->uuid,
            ]
        );
    }
}
