<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class UpdateDefaultUsersTools extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $uuid = null;
        $tool = Tools::query()->where('title', 'Gestion des tickets informatiques')->first();

        if (empty($tool)) {
            $uuid = $bridge->contentInsert('tools', [
                'bundle' => 'tools',
                'tools_link' => 'https://glpi.coutot-roehrig.com',
                'title' => 'Gestion des tickets informatiques',
                'icon' => '{"name":"external-link"}',
                'type' => 'node',
            ]);
        } else {
            $uuid = $tool->uuid;
        }

        $users = Users::all();
        foreach ($users as $user) {
            $tools = $user->tools;
            $tools = $tools->pluck('uuid')->toArray();

            if (in_array($uuid, $tools)) {
                continue;
            }

            if (count($tools) <= 2) {
                $tools[] = $uuid;
            } else {
                array_splice($tools, 2, 0, [$uuid]);
                if (count($tools) > 4) {
                    array_pop($tools);
                }
            }

            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $tools
            ]);
        }
    }
}
