<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldForSvgToCustomType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'custom',
            'svg',
            [
                'type' => BridgeContentType::IMAGE_FIELD,
                'name' => 'svg',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Bannière svg',
                    'en' => 'Svg banner',
                    'de' => 'Svg banner'
                ],
                'description'         => [
                    'fr' => 'Image svg pour la bannière',
                    'en' => 'Svg image for banner',
                    'de' => 'Svg-Bild für Banner'
                ],
                'settings' => [
                    'cardinality' => 1,
                    'file_extensions' => 'svg'
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'target_type' => 'file',
                    'display_field'   => false,
                    'display_default' => false,
                    'weight' => 1,
                ],
            ]
        );
    }
}
