<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ReworkUsersFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        // make expertise field multiple
        $bridge->switchCardinalityFromUnaryToMultiple('users', 'expertises');

        // make fields non required
        $fields = ['expertises', 'functions'];

        foreach ($fields as $field) {
            $bridge->updateFieldOptions('users', $field, [
                'required' => false
            ]);
        }
    }

    public function down(): void
    {
    }
}
