<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldForSvgToRhSpaces extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'rh_spaces',
            'svg',
            [
                'type' => BridgeContentType::IMAGE_FIELD,
                'name' => 'svg',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Bannière svg',
                    'en' => 'Svg banner'
                ],
                'description'         => [
                    'fr' => 'Image svg pour la bannière',
                    'en' => 'Svg image for banner'
                ],
                'settings' => [
                    'cardinality' => 1,
                    'file_extensions' => 'svg'
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'target_type' => 'file',
                    'display_field'   => false,
                    'display_default' => false,
                    'weight' => 1,
                ],
            ]
        );
    }
}
