<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class CreateCustomFormsNotificationType extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => false,
                'event'     => "Inside\Content\Events\ContentCreatedEvent",
                'model'     => "Inside\Content\Models\Contents\ContactServices",
                'type'      => 'system',
                'action'    => 'create',
                'condition' => null,
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.create.content.contact.form.title',
                    'description' => 'notifications.create.content.contact.form.description',
                    'mail'        => [
                        'subject'    => 'notifications.create.content.contact.form.mail.subject',
                        'text'       => 'notifications.create.content.contact.form.mail.content',
                        'buttonText' => 'notifications.create.content.contact.form.mail.buttonText',
                    ],
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
