<?php

use Illuminate\Database\Migrations\Migration;

class CreateContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->bridge->contentTypeDeleteField('users', 'users', 'function');
        $this->bridge->contentTypeDeleteField('users', 'users', 'shortcuts_menus');

        $this->migrateContent('simple_pages');
        $this->migrateContent('custom');
        $this->migrateContent('tools');
        $this->migrateContent('branches');
        $this->migrateContent('cities');
        $this->migrateContent('contracts_types');
        $this->migrateContent('folders');
        $this->migrateContent('documents');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('expertises');
        $this->migrateContent('functions');
        $this->migrateContent('jobs_offers');
        $this->migrateContent('languages');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('newsletters');
        $this->migrateContent('offices');
        $this->migrateContent('users');

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
