<?php

namespace Inside\CORO\Providers;

use Illuminate\Support\Facades\Event;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\CORO\Listeners\ContentCreatedListener;
use Inside\Providers\ServiceProvider as BaseServiceProvider;

/**
 * CORO Service provider.
 *
 * @category Class
 * @package  Inside\CORO\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * @var string[][]
     */
    protected $listen = [
        ContentCreatedEvent::class => [
            ContentCreatedListener::class
        ]
    ];

    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        foreach ($this->listen as $event => $listeners) {
            foreach ($listeners as $listener) {
                Event::listen($event, $listener);
            }
        }
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(
            __DIR__ . '/../../config/scheduler.php',
            'scheduler'
        );

        $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
    }
}
