<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'name' => 'users',
        'title' => [
            'fr' => 'Utilisateurs',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'type' => BridgeContentType::IMAGE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'editable' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Photo',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => $weight++,
            ],
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'firstname',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'editable' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Prénom',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'lastname',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'editable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Nom',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'linkedin',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'editable' => true,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Linkedin',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'expertises',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'editable' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Expertise',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['expertises'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'functions',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Fonction',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['functions'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'phone',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'editable' => false,
            'title' => [
                'fr' => 'fixe',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'mobile',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'editable' => false,
            'title' => [
                'fr' => 'Portable',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'shortcuts',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Raccourci',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'branches',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Succursale',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['branches'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'offices',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'editable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Bureau',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['offices'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'languages',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'editable' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Langues',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['languages'],
                'cardinality' => -1,
            ],
        ],
    ],
];
