<?php

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

if (!function_exists('get_entity')) {
    function get_entity(array $record, BridgeContent $bridge, string $bundle, string $column): ?array
    {
        $name = trim($record[$column]);

        if (empty($name)) {
            return null;
        }

        $query = call_user_func('Inside\\Content\\Models\\Contents\\' . Str::studly($bundle) . '::query');

        $entity = $query->where('title', $name)->first();

        if ($entity) {
            return [$entity->uuid];
        }

        $uuidBridge = $bridge->contentInsert($bundle, [
            'title' => $name,
            'type' => 'node',
            'bundle' => $bundle,
        ]);

        if ($uuidBridge) {
            return [$uuidBridge];
        }

        return null;
    }
}

if (!function_exists('parse_and_get_entity')) {
    function parse_and_get_entity(string $separator, string $cell, BridgeContent $bridge, string $bundle): array
    {
        $cell = trim($cell);
        if (empty($cell) || empty($separator)) {
            return [];
        }
        $values = explode($separator, $cell);
        $datas = [];
        foreach ($values as $value) {
            $value = trim($value);
            $query = call_user_func('Inside\\Content\\Models\\Contents\\' . Str::studly($bundle) . '::query');
            $entity = $query->where('title', $value)->first();
            if ($entity) {
                $datas[] = $entity->uuid;
            } else {
                $uuidBridge = $bridge->contentInsert($bundle, [
                    'title' => $value,
                    'type' => 'node',
                    'bundle' => $bundle,
                ]);

                if ($uuidBridge) {
                    $datas[] = $uuidBridge;
                }
            }
        }
        return $datas;
    }
}

return [
    'files' => [
        'coro' => [
            'path'      => env('CSV_CUSTOM_PATH', __DIR__ . '/../../../../imports/import.csv'),
            'separator' => ';',
            'fields'    => [
                'name'        => function ($record, BridgeContent $bridge) {
                    return trim($record['emailaddress']);
                },
                'mail'        => function ($record, BridgeContent $bridge) {
                    return trim($record['emailaddress']);
                },
                'firstname'   => function ($record, BridgeContent $bridge) {
                    return ucwords($record['givenname']);
                },
                'lastname'    => function ($record, BridgeContent $bridge) {
                    return ucwords(Str::upper($record['surname']));
                },
                'functions'    => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'functions', 'title');
                },
                'expertises' => function ($record, BridgeContent $bridge) {
                    return parse_and_get_entity('/', $record['extensionattribute1'], $bridge, 'expertises');
                },
                'phone' => function ($record, BridgeContent $bridge) {
                    $phone = $record['officephone'];
                    return strlen($phone) > 15 ? "" : $phone;
                },
                'mobile' => function ($record, BridgeContent $bridge) {
                    $mobile = $record["mobilephone"];
                    return strlen($mobile) > 15 ? "" : $mobile;
                },
                'branches' => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'branches', 'branch');
                },
                'languages' => function ($record, BridgeContent $bridge) {
                    if (isset($record['st'])) {
                        return parse_and_get_entity('-', $record['st'], $bridge, 'languages');
                    } else {
                        // fallback, if language does not exist in the csv file, we keep the ones the user already has
                        $user = Users::query()->where('email', trim($record['emailaddress']))->first();
                        if (!$user) {
                            return [];
                        }
                        return $user->languages->pluck('uuid')->toArray();
                    }
                },
                'shortcuts' => 'shortphone',
                'offices' => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'offices', 'office');
                },
                'status'      => function ($record, BridgeContent $bridge) {
                    return true;
                },
                'langcode'  => function ($record, BridgeContent $bridge) {
                    return 'fr';
                },
                'image' => function ($record, BridgeContent $bridge) {
                    $user = Users::query()->where('email', trim($record['emailaddress']))->first();

                    if ($user && $user->image !== null) {
                        return $user->image;
                    }
                    $name = Str::upper(str_replace(' ', '_', $record['surname']));
                    $firstname = str_replace(' ', '_', ucwords($record['givenname']));
                    $filename = $name . '_' . $firstname . '.jpg';
                    $filename = strtr(utf8_decode($filename), utf8_decode('àáâãäçèéêëìíîïñòóôõöùúûüýÿÀÁÂÃÄÇÈÉÊËÌÍÎÏÑÒÓÔÕÖÙÚÛÜÝ'), 'aaaaaceeeeiiiinooooouuuuyyAAAAACEEEEIIIINOOOOOUUUUY');
                    $imgPath = "profile/$filename";

                    if (!Storage::exists($imgPath)) {
                        return null;
                    }

                    $chunkId = Str::random(32);
                    $finalFolderPath = "chunks/$chunkId";
                    $finalPath = "$finalFolderPath/$filename";

                    Storage::makeDirectory($finalFolderPath);
                    Storage::copy($imgPath, $finalPath);
                    return $finalPath;
                }
            ]
        ]
    ],
];
