import { http } from '@inside-library/helpers/Http'

export const fetchTabsSpacesPages = async ({ $route }) => {
  try {
    const { data: tabsSpaces } = await http.get('content/tabs_spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'introduction',
        'banner'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return tabsSpaces[0]
  } catch (err) {
    throw new Error(err)
  }
}
