import { http } from '@inside-library/helpers/Http'

export const fetchPushLinkedin = async () => {
  try {
    const { data } = await http.get('content/cards_links', {
      fields: ['uuid', 'image', 'link', 'admin', 'content_type'],
      filters: {
        'status:eq': 1,
        'published_at:lte': 'now()',
        sort: 'published_at:desc',
        limit: 1
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchKeyNumbers = async () => {
  try {
    const { data } = await http.get('content/key_figures', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'value',
        'text',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        sort: 'weight:asc',
        'published_at:lte': 'now()',
        limit: 3
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}
