import TabsSpacesPages from '../pages/tabs-spaces/TabsSpacesPages'
import { fetchTabsSpacesPages } from '../components/tabs-spaces/tabs'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'AgendaListingPage',
    meta: { disabled: false }
  },
  {
    name: 'AgendaPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'published_at:lte': 'now()',
        'status:eq': 1
      },
      toolsFilters: {
        sort: 'weight:asc',
        'published_at:lte': 'now()',
        'status:eq': 1
      }
    }
  },
  {
    name: 'TabsSpacesPages',
    path: '/espaces-onglet/:slug/pages',
    component: withFetch(TabsSpacesPages, { size: 'xxl' })(fetchTabsSpacesPages)
  }
]
