import { http } from '@inside-library/helpers/Http'

export default {
  tabsSpaces: {
    add: async ({ data }) => {
      return {
        name: 'TabsSpacesPages',
        params: {
          slug: data.slug?.[0]
        }
      }
    }
  },
  tabs: {
    add: async ({ data }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: ['uuid', { tabs_spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })
      return {
        name: 'TabsSpacesPages',
        params: {
          slug: tabs[0]?.tabs_spaces.slug?.[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: ['uuid', { tabs_spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'TabsSpacesPages',
        params: {
          slug: tabs?.[0].tabs_spaces?.slug?.[0]
        }
      }
    }
  },
  tabsPages: {
    add: async ({ data }) => {
      const { data: tabsPage } = await http.get('content/tabs_pages', {
        fields: [
          { tabs: [{ tabs_spaces: { fields: ['uuid', 'title', 'slug'] } }] }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'TabsSpacesPages',
        params: {
          slug: tabsPage?.[0].tabs?.tabs_spaces?.slug?.[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: tabsPage } = await http.get('content/tabs_pages', {
        fields: [
          { tabs: [{ tabs_spaces: { fields: ['uuid', 'title', 'slug'] } }] }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'TabsSpacesPages',
        params: {
          slug: tabsPage?.[0].tabs?.tabs_spaces?.slug?.[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: tabsPage } = await http.get('content/tabs_pages', {
        fields: [
          { tabs: [{ tabs_spaces: { fields: ['uuid', 'title', 'slug'] } }] }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'TabsSpacesPages',
          params: {
            slug: tabsPage?.[0].tabs?.tabs_spaces?.slug?.[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
