<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/coiv-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/coiv-back/resources/assets/img/newsletter/bg.jpg',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'defaultCategoryColor' => '#D6002A',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#333333',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#D6002A',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#333333',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#333333'
            ],
        ],
        'new_members' => [
            'types' => ['movements'],
            'leftLineColor' => '#D6002A',
            'link' => [
                'sectionLinkUrl' => 'movements',
                'sectionTextColor' => '#D6002A',
            ],
        ],
        'activities' => [
            'link'        => null, // Pas de links
            'orientation' => 'horizontal',
            'defaultBackgroundColor' => '#FFFFF',
            'defaultValueColor' => '#2c3f50',
            'items'       => [
                'comments' => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\Comments::count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/coiv-back/resources/assets/img/newsletter/comment.png',
                    'titleStrKey'        => 'newsletter.comments_statistic',
                ],
                'likes'    => [
                    'callback'           => function () {
                        return \Inside\Reaction\Models\Reaction::where('type',
                            'like')->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/coiv-back/resources/assets/img/newsletter/like.png',
                    'titleStrKey'        => 'newsletter.likes_statistic',
                ],
                'users'    => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\Users::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/coiv-back/resources/assets/img/newsletter/directory.png',
                    'titleStrKey'        => 'newsletter.users_statistic',
                ],
                'news'     => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\News::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/coiv-back/resources/assets/img/newsletter/news.png',
                    'titleStrKey'        => 'newsletter.contents_statistic',
                ],
            ],
        ]
    ],
    'socials'      => [
        'backgroundColor' => '#D6002A',
        'links' => [
            'youtube' => [
                'url' => 'https://www.youtube.com/channel/UCbVhE4lCxQiP0-e0AqsSQGQ',
            ],
            'linkedin' => [
                'url' => 'https://fr.linkedin.com/company/coivia',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
