<?php

use Illuminate\Support\Collection;

return [
    'files' => [
        'coiv' => [
            'path' => env('CSV_USERS_PATH', __DIR__.'/../../../../imports/import.csv'),
            'separator' => env('CSV_USERS_SEPARATOR', ';'),
            'fields' => [
                'email' => 'mail',
                'name' => 'mail',
                'firstname' => 'prénom',
                'lastname' => 'nom',
                'phone' => 'téléphone',
                'mobile_phone' => 'mobile',
                'function' => 'fonction',
                'offices' => fn (array $record) => reference('offices')
                    ->identifiedBy('code')
                    ->from($record['direction'])
                    ->get(),
                'locations' => fn (array $record) => reference('locations')
                    ->identifiedBy('code')
                    ->from($record['localisation'])
                    ->get(),
                'referents' => fn (array $record) => reference('referents')
                    ->identifiedBy('code')
                    ->from($record['referent'])
                    ->get(),
                'managers' => fn (array $record) => reference('users')
                    ->identifiedBy('name')
                    ->from($record['responsable'])
                    ->withoutCreation()
                    ->first(),
                'rescuer' => fn (array $record) => (strtolower($record['secouriste']) === 'oui'),
                'status' => fn () => true,
                'is_maintenance' => fn () => false,
            ],
            'original_fields' => [
              'mail' => 'mail',
              'prénom' => 'firstname',
              'nom' => 'lastname',
              'téléphone' => 'word',
              'mobile' => 'word',
              'fonction' => 'word',
              'direction' => 'word',
              'localisation' => 'word',
              'referent' => 'word',
              'responsable' => 'word',
              'secouriste' => 'word',
            ],
        ],
    ],
];
